
cp_59968(QUATERNION) {


/*  Copyright Matthew Benesi   All Rights Reserved  */
/*  These formulas are only authorized for distribution with ChaosPro */
/*  Derivative works may not be distributed without authors permission   */
/*  4/27/2010 */

/* NEEDS TO BE CLEANED UP: a few steps and variables can be eliminated, and may be eliminated in future combined version of Benesi set  */


parameter complex power;
parameter real bailout,v;
parameter quaternion p,perturb;
parameter quaternion c,time,time2;
real sx,sy,sz,sw,sv,su,s7,s8,s9,s10;
real nx,ny,nz,nw,nv,nu,n7,n8,n9,n10;
real kw,t1,t2,t3,t4,zparta,zpartb,bail;
complex zparts;
int imy;
real i,r,theta,phi,tau,beta,delta,a7,a8,a9,a10,r2,r3,a,b;
quaternion nquat,olez;
parameter int fractaltype;
real cr,ci,cj,ck,cl,cm,c7,c8,c9,c10;
real pixelr,pixeli,pixelj,pixelk;
parameter real n;
parameter bool juliaMode;

	void init(void)
	{
		if (juliaMode) {
			z=pixel;
		} else {
			z=c;
		}
		olez=(0,0,0,0);
		sx=part_r(z);
		sy=part_i(z);
		sz=part_j(z);
		sw=part_k(time);
		sv=part_j(time);
		su=part_i(time);
		s7=part_r(time);
		s8=part_k(time2);
		s9=part_j(time2);
		s10=part_i(time2);
		
		/* kw=part_k(time); */
		nquat=quaternion(n,0,0,0);

		cr=part_r(c);
		ci=part_i(c);
		cj=part_j(c);
		ck=part_k(c);
		cl=0;
		cm=0;
		c7=0;
		c8=0;
		c9=0;
		c10=0;
		
		imy=1;
		pixelr=part_r(pixel);
		pixeli=part_i(pixel);
		pixelj=part_j(pixel);
		pixelk=part_k(pixel);
		/*
		r2=sqrt(pixelr^2+pixeli^2+pixelj^2);
	     theta=atan2(sqrt(pixelr^2+pixeli^2)+flip(sqrt(pixeli^2+pixelj^2)))/2;
		zparts=complex(r2*cos(theta),r2*sin(theta));
		zparta=part_r(zparts);
		zpartb=part_i(zparts);*/
	}
	void loop(void)
	{
		
		if (fractaltype=="Mandelbulb") {
			r2=sqrt(sx^2+sy^2+sz^2+part_r(time2));
			theta=atan2(sqrt(sx^2+sy^2)+flip(sz));
			phi=atan2(sy+flip(sx));
			
			if (n==2) {
				r3=r2*r2;
			} else if (n==3) {
				r3=r2*r2*r2;
			} else if (n==4) {
				r3=sqr(sqr(r2));
			} else if (n==5) {
				r3=sqr(sqr(r2))*r2;
			} else if (n==6) {
				r3=sqr(sqr(r2))*sqr(r2);
			} else if (n==7) {
				r3=sqr(sqr(r2))*sqr(r2)*r2;
			} else if (n==8) {
				r3=sqr(sqr(sqr(r2)));
			} else {
				r3=r2^n;
			}
			nx=r3*sin(n*theta)*cos(n*phi);
			ny=r3*sin(n*theta)*sin(n*phi);
			nz=r3*cos(n*theta);
			
			if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
			} else {
				sx=nx+pixelr;
				sy=ny+pixeli;
				sz=nz+pixelj;
			}
			z=quaternion(sx,sy,sz,0);
			bail=sx^2+sy^2+sz^2;
		}else if (fractaltype=="3d Timed") {
			/* sw=kw; */
			r2=sqrt(sx^2+sy^2+sz^2+sw^2+part_r(time2));
			theta=atan2(sqrt(sx^2+sy^2)+flip(sz));
			phi=atan2(sy+flip(sx));
			/* tau=atan2(sqrt(sx^2+sy^2+sz^2)+flip(sw))  */
			
			if (n==2) {
				r3=r2*r2;
			} else if (n==3) {
				r3=r2*r2*r2;
			} else if (n==4) {
				r3=sqr(sqr(r2));
			} else if (n==5) {
				r3=sqr(sqr(r2))*r2;
			} else if (n==6) {
				r3=sqr(sqr(r2))*sqr(r2);
			} else if (n==7) {
				r3=sqr(sqr(r2))*sqr(r2)*r2;
			} else if (n==8) {
				r3=sqr(sqr(sqr(r2)));
			} else {
				r3=r2^n;
			}
			nx=r3*sin(v*theta)*cos(v*phi);
			ny=r3*sin(v*theta)*sin(v*phi);
			nz=r3*cos(v*theta);
			nw=sw;
			
			if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
				sw=nw+ck;
			} else {
				sx=nx+pixelr;
				sy=ny+pixeli;
				sz=nz+pixelj;
				sw=nw+part_k(time);
			}
			z=quaternion(sx,sy,sz,sw);
			z=z^p+c;
			sx=part_r(z);
			sy=part_i(z);
			sz=part_j(z);
			sw=part_k(z);
			bail=sx^2+sy^2+sz^2+sw^2;
		}else if (fractaltype=="4d Bulb") {
			r2=sqrt(sx^2+sy^2+sz^2+sw^2+part_r(time2));
			theta=atan2(sqrt(sx^2+sy^2)+flip(sqrt(sz^2+sw^2)));
			phi=atan2(sx+flip(sy)); /* exchanged sx/sy */
			tau=atan2(sz+flip(sw));
			
			if (n==2) {
				r3=r2*r2;
			} else if (n==3) {
				r3=r2*r2*r2;
			} else if (n==4) {
				r3=sqr(sqr(r2));
			} else if (n==5) {
				r3=sqr(sqr(r2))*r2;
			} else if (n==6) {
				r3=sqr(sqr(r2))*sqr(r2);
			} else if (n==7) {
				r3=sqr(sqr(r2))*sqr(r2)*r2;
			} else if (n==8) {
				r3=sqr(sqr(sqr(r2)));
			} else {
				r3=r2^n;
			}
			nx=r3*sin(v*theta)*cos(v*phi);
			ny=r3*sin(v*theta)*sin(v*phi);
			nz=r3*cos(v*theta)*cos(v*tau);
			nw=r3*cos(v*theta)*sin(v*tau);
			
			if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
				sw=nw+ck;
			} else {
				sx=nx+pixelr;
				sy=ny+pixeli;
				sz=nz+pixelj;
				sw=nw+part_k(time);
			}
			z=quaternion(sx,sy,sz,sw);
			z=z^p+c;
			sx=part_r(z);
			sy=part_i(z);
			sz=part_j(z);
			sw=part_k(z);
			bail=sx^2+sy^2+sz^2+sw^2;
			
		}else if (fractaltype=="4d Pretty") {
			
			
			r2=sqrt(sx^2+sy^2+sz^2+sw^2+part_r(time2));
			theta=atan2(sqrt(sx^2+sy^2)+flip(sqrt(sz^2+sw^2)));
			phi=atan2(sy+flip(sx)); 
			tau=atan2(sw+flip(sz));/* exchanged sz/sw */
			
			if (n==2) {
				r3=r2*r2;
			} else if (n==3) {
				r3=r2*r2*r2;
			} else if (n==4) {
				r3=sqr(sqr(r2));
			} else if (n==5) {
				r3=sqr(sqr(r2))*r2;
			} else if (n==6) {
				r3=sqr(sqr(r2))*sqr(r2);
			} else if (n==7) {
				r3=sqr(sqr(r2))*sqr(r2)*r2;
			} else if (n==8) {
				r3=sqr(sqr(sqr(r2)));
			} else {
				r3=r2^n;
			}
			nx=r3*sin(v*theta)*cos(v*phi);
			ny=r3*sin(v*theta)*sin(v*phi);
			nz=r3*cos(v*theta)*cos(v*tau);
			nw=r3*cos(v*theta)*sin(v*tau);
			
			if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
				sw=nw+ck;
			} else {
				sx=nx+pixelr;
				sy=ny+pixeli;
				sz=nz+pixelj;
				sw=nw+part_k(time);
			}
			z=quaternion(sx,sy,sz,sw);
			z=z^p+c;
			sx=part_r(z);
			sy=part_i(z);
			sz=part_j(z);
			sw=part_k(z);
			
			bail=sx^2+sy^2+sz^2+sw^2;
			
		}else if (fractaltype=="3d Bulb") {
			
			r2=sqrt(sx^2+sy^2+sz^2+part_r(time2));
			theta=atan2(sqrt(sx^2+sy^2)+flip(sz));
			phi=atan2(sy+flip(sx));
			
			
			if (n==2) {
				r3=r2*r2;
			} else if (n==3) {
				r3=r2*r2*r2;
			} else if (n==4) {
				r3=sqr(sqr(r2));
			} else if (n==5) {
				r3=sqr(sqr(r2))*r2;
			} else if (n==6) {
				r3=sqr(sqr(r2))*sqr(r2);
			} else if (n==7) {
				r3=sqr(sqr(r2))*sqr(r2)*r2;
			} else if (n==8) {
				r3=sqr(sqr(sqr(r2)));
			} else {
				r3=r2^n;
			}
			nx=r3*cos(v*theta)*sin(v*phi);
			ny=r3*cos(v*theta)*cos(v*phi);
			nz=r3*sin(v*theta);
			
			
			if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
				
			} else {
				sx=nx+pixelr;
				sy=ny+pixeli;
				sz=nz+pixelj;
				
			}
			z=quaternion(sx,sy,sz,0);
			/*z=z^p+c;
			sx=part_r(z);
			sy=part_i(z);
			sz=part_j(z);*/
			bail=sx^2+sy^2+sz^2;
			
		}else if (fractaltype=="3d Bulb B") {
			/*zparts=zparts^n;
			sx=part_r(zparts)+zparta;
			sy=part_i(zparts)+zpartb;
			*/
			if (v==1) {
			nx=sqr(sx)-sqr(sy)-sqr(sz)-sqr(sw);
			ny=2*(sx+sz+sw)*sy;
			nz=2*(sx+sw)*sz;
			nw=2*sx*sw;}
			else if (v==0) {
			nx=sx;
			ny=sy;
			nz=sz;
			nw=sw;}
			
			i=1;
			while (i<=n) {
			cr=sx*nx-sy*ny-sz*nz-sw*nw;
			ci=(sx+sz+sw)*ny+sy*(nx+nz+nw);
			cj=(sx+sw)*nz+sz*(nx+nw);
			ck=sx*nw+sw*nx;
			nx=sx*cr-sy*ci-sz*cj-sw*ck;
			ny=(sx+sz+sw)*ci+sy*(cr+cj+ck);
			nz=(sx+sw)*cj+sz*(cr+ck);
			nw=sx*ck+sw*cr;
			i=i+1;
			}			
				sx=nx+pixelr;
				sy=ny+pixeli;
				sz=nz+pixelj;
				sw=nw+part_k(time);
			bail=sx^2+sy^2+sz^2+sw^2;
			/*
			zparts=complex(sx,sy);
			bail=sx^2+sy^2;*/
			
		}else if (fractaltype=="5d Bulb") {
			
			
			r2=sqrt(sx^2+sy^2+sz^2+sw^2+sv^2+part_r(time2));
			theta=atan2(sqrt(sx^2+sy^2)+flip(sqrt(sz^2+sw^2)));
			phi=atan2(sx+flip(sy)); /* exchanged sx/sy */
			tau=atan2(sz+flip(sw));
			beta=atan2(sqrt(sx^2+sy^2+sz^2+sw^2)+flip (sv));
			
			if (n==2) {
				r3=r2*r2;
			} else if (n==3) {
				r3=r2*r2*r2;
			} else if (n==4) {
				r3=sqr(sqr(r2));
			} else if (n==5) {
				r3=sqr(sqr(r2))*r2;
			} else if (n==6) {
				r3=sqr(sqr(r2))*sqr(r2);
			} else if (n==7) {
				r3=sqr(sqr(r2))*sqr(r2)*r2;
			} else if (n==8) {
				r3=sqr(sqr(sqr(r2)));
			} else {
				r3=r2^n;
			}
			nx=r3*sin(v*theta)*cos(v*phi)*cos(v*beta);
			ny=r3*sin(v*theta)*sin(v*phi)*cos(v*beta);
			nz=r3*cos(v*theta)*cos(v*tau)*cos(v*beta);
			nw=r3*cos(v*theta)*sin(v*tau)*cos(v*beta);
			nv=r3*sin(v*beta);
			
			if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
				sw=nw+ck;
				sv=nv+cl;
			} else {
				sx=nx+pixelr;
				sy=ny+pixeli;
				sz=nz+pixelj;
				sw=nw+part_k(time);
				sv=nv+part_j(time);
			}
			z=quaternion(sx,sy,sz,sw);
			if (p>=2) {z=z^p+c;
			sx=part_r(z);
			sy=part_i(z);
			sz=part_j(z);
			sw=part_k(z);}
			
				bail=sx^2+sy^2+sz^2+sw^2+sv^2;
		}else if (fractaltype=="6d Bulb") {
			
			
			r2=sqrt(sx^2+sy^2+sz^2+sw^2+sv^2+su^2+part_r(time2));
			theta=atan2(sqrt(sx^2+sy^2)+flip(sqrt(sz^2+sw^2)));
			phi=atan2(sx+flip(sy)); /* exchanged sx/sy */
			tau=atan2(sz+flip(sw));
			beta=atan2(sqrt(sx^2+sy^2+sz^2+sw^2)+flip (sqrt(sv^2+su^2)));
			delta=atan2(sv+flip(su));
			
			if (n==2) {
				r3=r2*r2;
			} else if (n==3) {
				r3=r2*r2*r2;
			} else if (n==4) {
				r3=sqr(sqr(r2));
			} else if (n==5) {
				r3=sqr(sqr(r2))*r2;
			} else if (n==6) {
				r3=sqr(sqr(r2))*sqr(r2);
			} else if (n==7) {
				r3=sqr(sqr(r2))*sqr(r2)*r2;
			} else if (n==8) {
				r3=sqr(sqr(sqr(r2)));
			} else {
				r3=r2^n;
			}
			nx=r3*sin(v*theta)*cos(v*phi)*cos(v*beta);
			ny=r3*sin(v*theta)*sin(v*phi)*cos(v*beta);
			nz=r3*cos(v*theta)*cos(v*tau)*cos(v*beta);
			nw=r3*cos(v*theta)*sin(v*tau)*cos(v*beta);
			nv=r3*sin(v*beta)*cos(v*delta);
			nu=r3*sin(v*beta)*sin(v*delta);
			
			if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
				sw=nw+ck;
				sv=nv+cl;
				su=nu+cm;
			} else {
				sx=nx+pixelr;
				sy=ny+pixeli;
				sz=nz+pixelj;
				sw=nw+part_k(time);
				sv=nv+part_j(time);
				su=nu+part_i(time);
			}
			z=quaternion(sx,sy,sz,sw);
			if (p>=2) {z=z^p+c;
			sx=part_r(z);
			sy=part_i(z);
			sz=part_j(z);
			sw=part_k(z);}
			
			bail=sx^2+sy^2+sz^2+sw^2+sv^2+su^2;
		}else if (fractaltype=="10d Bulb") {
			
			
			r2=sqrt(sx^2+sy^2+sz^2+sw^2+sv^2+su^2+s7^2+s8^2+s9^2+s10^2+part_r(time2));
			theta=atan2(sqrt(sx^2+sy^2)+flip(sqrt(sz^2+sw^2)));
			phi=atan2(sx+flip(sy)); /* exchanged sx/sy */
			tau=atan2(sz+flip(sw));
			beta=atan2(sqrt(sx^2+sy^2+sz^2+sw^2)+flip (sqrt(sv^2+su^2)));
			delta=atan2(sv+flip(su));
			a7=atan2(sqrt(sx^2+sy^2+sz^2+sw^2+sv^2+su^2)+flip(sqrt(s7^2+s8^2+s9^2+s10^2)));
			a8=atan2(sqrt(s7^2+s8^2)+flip(sqrt(s9^2+s10^2)));
			a9=atan2(s7+flip(s8));
			a10=atan2(s9+flip(s10));
			
			if (n==2) {
				r3=r2*r2;
			} else if (n==3) {
				r3=r2*r2*r2;
			} else if (n==4) {
				r3=sqr(sqr(r2));
			} else if (n==5) {
				r3=sqr(sqr(r2))*r2;
			} else if (n==6) {
				r3=sqr(sqr(r2))*sqr(r2);
			} else if (n==7) {
				r3=sqr(sqr(r2))*sqr(r2)*r2;
			} else if (n==8) {
				r3=sqr(sqr(sqr(r2)));
			} else {
				r3=r2^n;
			}
			
			nx=r3*sin(v*theta)*cos(v*phi)*cos(v*beta)*cos(v*a7);
			ny=r3*sin(v*theta)*sin(v*phi)*cos(v*beta)*cos(v*a7);
			nz=r3*cos(v*theta)*cos(v*tau)*cos(v*beta)*cos(v*a7);
			nw=r3*cos(v*theta)*sin(v*tau)*cos(v*beta)*cos(v*a7);
			nv=r3*sin(v*beta)*cos(v*delta)*cos(v*a7);
			nu=r3*sin(v*beta)*sin(v*delta)*cos(v*a7);
			n7=r3*sin(v*a7)*cos(v*a8)*cos(v*a9);
			n8=r3*sin(v*a7)*cos(v*a8)*sin(v*a9);
			n9=r3*sin(v*a7)*sin(v*a8)*cos(v*a10);
			n10=r3*sin(v*a7)*sin(v*a8)*sin(v*a10);
			if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
				sw=nw+ck;
				sv=nv+cl;
				su=nu+cm;
				s7=n7+c7;
				s8=n8+c8;
				s9=n9+c9;
				s10=n10+c10;
			} else {
				sx=nx+pixelr;
				sy=ny+pixeli;
				sz=nz+pixelj;
				sw=nw+part_k(time);
				sv=nv+part_j(time);
				su=nu+part_i(time);
				s7=n7+part_r(time);
				s8=n8+part_k(time2);
				s9=n9+part_j(time2);
				s10=n10+part_i(time2);
			}
			z=quaternion(sx,sy,sz,sw);
			
			bail=sx^2+sy^2+sz^2+sw^2+sv^2+su^2+s7^2+s8^2+s9^2+s10^2;
			/*if (p>=2) {z=z^p+c;
			sx=part_r(z);
			sy=part_i(z);
			sz=part_j(z);
			sw=part_k(z);}*/
		}
	}
	bool bailout(void)
	{
	 
		return(bail<bailout);
	
	}

	void description(void)
	{
		this.title = "Timed 4d thru 10d";

		bailout.caption = "Bailout Value";
		bailout.default = 4.0;
		bailout.min = .1;
		bailout.hint = "Defines the bailout radius: As soon as a pixel falls outside a circle with this radius, the iteration stops.";
		
		c.caption="c";
		c.default=(0,0,0,0);
		c.hint="Parameter for this formula";
		
		fractaltype.caption="Formula";
		fractaltype.enum="Mandelbulb\n3d Timed\n4d Bulb\n4d Pretty\n3d Bulb\n5d Bulb\n6d Bulb\n10d Bulb\n3d Bulb B";
		fractaltype.default=0;
		
		juliaMode.caption="Julia Mode";
		juliaMode.default=false;
		juliaMode.hint="If checked, Julia mode is enabled, otherwise Mandelbrot mode";
		
		n.caption="Power";
		n.default=0;
		n.min=0;
		n.hint="Power: Choose 3 to 8 for faster calculation";
		
		v.caption="value";
		v.default=1;		
		
		
		time.caption="time 7..4";
		time.default=(0,0,0,0);
		time.hint="Time axis: Choose values between -2.0000 and 2.0000";
		
	
		
		time2.caption="time 11..8";
		time2.default=(0,0,0,0);
		time2.hint="Time axis: Choose values between -2.0000 and 2.0000";
		
		p.caption="quat Power";
		p.default=(1,0,0,0);
	}
}